//+------------------------------------------------------------------+
//|                                               Market Thermometer |
//|                                                            mikep |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "mikep"
#property link      ""

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 White
#property indicator_color2 Red
//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];

extern int ThermoMAPeriod = 13;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(0,ExtMapBuffer1);
   
   SetIndexStyle(1,DRAW_LINE,STYLE_SOLID,2);
   SetIndexBuffer(1,ExtMapBuffer2);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   int    i,limit;
   double thermo, ma;

   limit=Bars-1;
   for(i=0;i<limit;i++)
   {
      thermo = MathMax(iHigh(NULL,0,i) - iHigh(NULL,0,i+1), iLow(NULL,0,i+1) - iLow(NULL,0,i));
      if (thermo < 0) thermo = 0;
      ExtMapBuffer1[i]=thermo;
   }
   for(i=0;i<limit;i++)
   {
      ExtMapBuffer2[i]=iMAOnArray(ExtMapBuffer1,0,ThermoMAPeriod,0,MODE_EMA,i);
   }  
   return(0);
}
//+------------------------------------------------------------------+